# SISVOT - Sistema de Votación Escolar

Aplicación Laravel + MySQL para elecciones escolares (grados 1° a 11°) con:

- elección de **personero** y **contralor** en un solo tarjetón,
- carga de candidatos (rol, número y foto) por rango de fechas,
- opción de **voto en blanco** por cada cargo,
- control de **un voto por estudiante**,
- **certificado de votación** verificable y descargable en PDF,
- panel administrativo con escrutinio, historial y cierre oficial,
- panel de **jurado** con participación y gráfico,
- inicio de votación **manual** mediante botón **Iniciar votación**,
- separación entre identidad del votante y contenido del voto (voto secreto).

## Seguridad implementada

- Voto único: el estudiante se marca con `has_voted` en transacción con bloqueo (`lockForUpdate`).
- Secreto del voto: la tabla `ballots` no guarda `student_id`.
- Confidencialidad: la participación va en `voting_receipts`, separada del tarjetón.
- Integridad: votos y certificados no se pueden editar ni borrar desde modelo.
- Verificación: cada certificado tiene `receipt_code` + `verification_hash`.

## Instalación rápida

1. Configura `.env` con credenciales de MySQL.
2. Ejecuta:

```bash
php artisan migrate:fresh --seed
php artisan serve
```

3. Abre `http://127.0.0.1:8000`.

## Accesos y configuración inicial

- Si no existe administrador, ingresa a `/setup-inicial` para crear la cuenta admin.
- Login admin: `/admin/login`.
- Login jurado: `/jury/login` (los crea el admin desde el dashboard).

Estudiantes demo (seed):

- `STU001` / `1234`
- `STU005` / `1234`
- `STU008` / `1234`
- `STU011` / `1234`

## Flujo operativo

1. Admin crea elección (ventana de candidatos + fecha fin).
2. Admin registra candidatos durante la ventana permitida.
3. Admin pulsa **Iniciar votación** para habilitar el sufragio.
4. Estudiante inicia sesión y vota (con opción en blanco).
5. Sistema emite certificado verificable.
6. Admin/Jurado visualizan escrutinio; ganador solo aparece al cierre.
7. Admin cierra oficialmente la elección y puede descargar acta PDF.

## Importación CSV de estudiantes

Encabezados requeridos:

- `full_name`
- `grade_level`
- `login_code`
- `pin` **o** `login_pin_hash`

Opcional:

- `document_number`

Notas:

- Si envías `pin`, el sistema lo cifra.
- Si envías `login_pin_hash`, se guarda directamente (bcrypt/argon).
- Si `login_code` ya existe, el estudiante se actualiza.

## Convertir PIN plano a hash (archivo listo para importar)

Comando incluido:

```bash
php artisan sisvot:hash-student-pins "C:\ruta\entrada.csv" "C:\ruta\salida.csv"
```

Para conservar también la columna `pin` en la salida:

```bash
php artisan sisvot:hash-student-pins "C:\ruta\entrada.csv" "C:\ruta\salida.csv" --keep-pin
```
