<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use LogicException;

class Ballot extends Model
{
    use HasFactory;

    protected static function booted(): void
    {
        static::updating(function () {
            throw new LogicException('Los votos no se pueden modificar.');
        });

        static::deleting(function () {
            throw new LogicException('Los votos no se pueden eliminar.');
        });
    }

    protected $fillable = [
        'election_id',
        'ballot_uuid',
        'personero_candidate_id',
        'contralor_candidate_id',
        'personero_blank',
        'contralor_blank',
        'submitted_at',
    ];

    protected $casts = [
        'personero_blank' => 'boolean',
        'contralor_blank' => 'boolean',
        'submitted_at' => 'datetime',
    ];

    public function election()
    {
        return $this->belongsTo(Election::class);
    }

    public function personeroCandidate()
    {
        return $this->belongsTo(Candidate::class, 'personero_candidate_id');
    }

    public function contralorCandidate()
    {
        return $this->belongsTo(Candidate::class, 'contralor_candidate_id');
    }
}
