<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Candidate extends Model
{
    use HasFactory;

    protected $fillable = [
        'election_id',
        'grade_id',
        'role',
        'display_number',
        'full_name',
        'photo_path',
        'proposal',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function election()
    {
        return $this->belongsTo(Election::class);
    }

    public function grade()
    {
        return $this->belongsTo(Grade::class);
    }

    public function getPhotoUrlAttribute(): ?string
    {
        if (! $this->photo_path) {
            return null;
        }

        return route('media.public', ['path' => $this->photo_path]);
    }
}
