<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InstitutionSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'school_name',
        'election_year',
        'school_logo_path',
        'configured_once',
    ];

    protected $casts = [
        'configured_once' => 'boolean',
    ];

    public function getLogoUrlAttribute(): ?string
    {
        if (! $this->school_logo_path) {
            return null;
        }

        return route('media.public', ['path' => $this->school_logo_path]);
    }
}
