<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Hash;

class Student extends Model
{
    use HasFactory;

    protected $fillable = [
        'grade_id',
        'full_name',
        'document_number',
        'login_code',
        'login_pin_hash',
        'has_voted',
        'voted_at',
    ];

    protected $casts = [
        'has_voted' => 'boolean',
        'voted_at' => 'datetime',
    ];

    public function grade()
    {
        return $this->belongsTo(Grade::class);
    }

    public function receipt()
    {
        return $this->hasOne(VotingReceipt::class);
    }

    public function setPinAttribute(string $value): void
    {
        $this->attributes['login_pin_hash'] = Hash::make($value);
    }
}
