<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use LogicException;

class VotingReceipt extends Model
{
    use HasFactory;

    protected static function booted(): void
    {
        static::updating(function () {
            throw new LogicException('El certificado no se puede modificar.');
        });

        static::deleting(function () {
            throw new LogicException('El certificado no se puede eliminar.');
        });
    }

    protected $fillable = [
        'election_id',
        'student_id',
        'receipt_code',
        'verification_hash',
        'voted_at',
    ];

    protected $casts = [
        'voted_at' => 'datetime',
    ];

    public function election()
    {
        return $this->belongsTo(Election::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }
}
