<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('candidates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('election_id')->constrained()->cascadeOnDelete();
            $table->foreignId('grade_id')->constrained()->cascadeOnDelete();
            $table->enum('role', ['personero', 'contralor']);
            $table->unsignedTinyInteger('display_number');
            $table->string('full_name');
            $table->string('photo_path')->nullable();
            $table->text('proposal')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->unique(['election_id', 'role', 'display_number']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('candidates');
    }
};
