<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ballots', function (Blueprint $table) {
            $table->id();
            $table->foreignId('election_id')->constrained()->cascadeOnDelete();
            $table->uuid('ballot_uuid')->unique();
            $table->foreignId('personero_candidate_id')->nullable()->constrained('candidates')->nullOnDelete();
            $table->foreignId('contralor_candidate_id')->nullable()->constrained('candidates')->nullOnDelete();
            $table->boolean('personero_blank')->default(false);
            $table->boolean('contralor_blank')->default(false);
            $table->dateTime('submitted_at');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ballots');
    }
};
