@extends('layouts.app')

@section('content')
<div class="max-w-xl mx-auto nb-card">
    <div class="nb-spiral" id="sp-login-setup" data-spiral-count="10"></div>
    <div class="nb-body">
    <h1 class="text-3xl font-bold text-slate-900">Configuración Inicial</h1>
    <p class="mt-2 hand text-slate-700">Primer ingreso: crea la cuenta administradora principal del sistema.</p>

    <form method="POST" action="{{ route('setup.initial.submit') }}" class="mt-6 space-y-5">
        @csrf
        <div>
            <label class="block text-sm font-semibold text-slate-700 mb-2">Nombre completo</label>
            <input class="w-full rounded-xl border border-slate-300 px-4 py-3" type="text" name="name" value="{{ old('name') }}" required>
            @error('name') <div class="mt-2 text-sm text-red-600">{{ $message }}</div> @enderror
        </div>
        <div>
            <label class="block text-sm font-semibold text-slate-700 mb-2">Correo administrador</label>
            <input class="w-full rounded-xl border border-slate-300 px-4 py-3" type="email" name="email" value="{{ old('email') }}" required>
            @error('email') <div class="mt-2 text-sm text-red-600">{{ $message }}</div> @enderror
        </div>
        <div>
            <label class="block text-sm font-semibold text-slate-700 mb-2">Contraseña</label>
            <input class="w-full rounded-xl border border-slate-300 px-4 py-3" type="password" name="password" required>
            @error('password') <div class="mt-2 text-sm text-red-600">{{ $message }}</div> @enderror
        </div>
        <div>
            <label class="block text-sm font-semibold text-slate-700 mb-2">Confirmar contraseña</label>
            <input class="w-full rounded-xl border border-slate-300 px-4 py-3" type="password" name="password_confirmation" required>
        </div>

        <button class="w-full h-16 rounded-2xl bg-blue-600 text-white text-lg font-semibold hover:bg-blue-700 transition" type="submit">Crear administrador inicial</button>
    </form>
    </div>
</div>
@endsection
