@extends('layouts.app')

@section('content')
<div class="max-w-xl mx-auto nb-card">
    <div class="nb-spiral" id="sp-login-jury" data-spiral-count="10"></div>
    <div class="nb-body">
    <h1 class="text-3xl font-bold text-slate-900">Acceso Jurado</h1>
    <p class="mt-2 hand text-slate-700">Seguimiento de participación y resultados según estado de la elección.</p>

    <form method="POST" action="{{ route('jury.login.submit') }}" class="mt-6 space-y-5">
        @csrf
        <div>
            <label class="block text-sm font-semibold text-slate-700 mb-2">Correo jurado</label>
            <input class="w-full rounded-xl border border-slate-300 px-4 py-3 text-base focus:ring-2 focus:ring-blue-500 focus:border-blue-500" type="email" name="email" value="{{ old('email') }}" required>
            @error('email') <div class="mt-2 text-sm text-red-600">{{ $message }}</div> @enderror
        </div>
        <div>
            <label class="block text-sm font-semibold text-slate-700 mb-2">Contraseña</label>
            <input class="w-full rounded-xl border border-slate-300 px-4 py-3 text-base focus:ring-2 focus:ring-blue-500 focus:border-blue-500" type="password" name="password" required>
            @error('password') <div class="mt-2 text-sm text-red-600">{{ $message }}</div> @enderror
        </div>

        <button class="w-full h-16 rounded-2xl bg-blue-600 text-white text-lg font-semibold hover:bg-blue-700 transition" type="submit">Entrar</button>
    </form>

    <div class="mt-5">
        <a class="inline-flex w-full items-center justify-center h-14 rounded-2xl bg-slate-700 text-white font-semibold hover:bg-slate-800 transition" href="{{ route('login.form') }}">Volver a inicio</a>
    </div>
    </div>
</div>
@endsection
