<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\JuryController;
use App\Http\Controllers\MediaController;
use App\Http\Controllers\VotingController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [AuthController::class, 'showLogin'])->name('login.form');
Route::get('/media/public/{path}', [MediaController::class, 'showPublic'])->where('path', '.*')->name('media.public');
Route::get('/setup-inicial', [AuthController::class, 'showInitialSetup'])->name('setup.initial.form');
Route::post('/setup-inicial', [AuthController::class, 'initialSetup'])->name('setup.initial.submit');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::get('/votar', [VotingController::class, 'showVoteForm'])->name('voting.form');
Route::post('/votar', [VotingController::class, 'submitVote'])->name('voting.submit');
Route::get('/certificado', [VotingController::class, 'showReceipt'])->name('voting.receipt.show');
Route::get('/certificado/pdf', [VotingController::class, 'downloadReceiptPdf'])->name('voting.receipt.pdf');
Route::get('/certificado/verificar/{receiptCode}', [VotingController::class, 'verifyReceipt'])->name('voting.receipt.verify');

Route::get('/admin/login', [AuthController::class, 'showAdminLogin'])->name('admin.login.form');
Route::post('/admin/login', [AuthController::class, 'adminLogin'])->name('admin.login.submit');
Route::post('/admin/logout', [AuthController::class, 'adminLogout'])->name('admin.logout');
Route::get('/admin/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
Route::post('/admin/institution', [AdminController::class, 'updateInstitution'])->name('admin.institution.update');
Route::post('/admin/elections', [AdminController::class, 'storeElection'])->name('admin.elections.store');
Route::post('/admin/election/start', [AdminController::class, 'startElectionVoting'])->name('admin.election.start');
Route::post('/admin/juries', [AdminController::class, 'storeJury'])->name('admin.juries.store');
Route::get('/admin/students/template-csv', [AdminController::class, 'downloadStudentsTemplateCsv'])->name('admin.students.template');
Route::post('/admin/students/import', [AdminController::class, 'importStudentsCsv'])->name('admin.students.import');
Route::post('/admin/candidates', [AdminController::class, 'storeCandidate'])->name('admin.candidates.store');
Route::get('/admin/dashboard/acta-pdf', [AdminController::class, 'exportPdf'])->name('admin.dashboard.pdf');
Route::post('/admin/election/close', [AdminController::class, 'closeElection'])->name('admin.election.close');

Route::get('/jury/login', [AuthController::class, 'showJuryLogin'])->name('jury.login.form');
Route::post('/jury/login', [AuthController::class, 'juryLogin'])->name('jury.login.submit');
Route::post('/jury/logout', [AuthController::class, 'juryLogout'])->name('jury.logout');
Route::get('/jury/dashboard', [JuryController::class, 'dashboard'])->name('jury.dashboard');
