

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <div class="nb-card">
        <div class="nb-spiral" id="sp-jury-1" data-spiral-count="10"></div>
        <div class="nb-body">
        <h1 class="text-3xl font-bold text-slate-900">Panel del Jurado</h1>
        <p class="mt-2 hand text-slate-700">Monitoreo de participación y resultados de la elección.</p>
        </div>
    </div>

    <?php if(!$election): ?>
        <div class="al-warn">No hay elección configurada.</div>
    <?php else: ?>
        <div class="nb-card">
            <div class="nb-spiral" id="sp-jury-2" data-spiral-count="10"></div>
            <div class="nb-body space-y-3">
            <p><span class="font-semibold">Elección:</span> <?php echo e($election->name); ?></p>
            <p><span class="font-semibold">Estado:</span> <?php echo e($election->is_active ? 'Activa' : 'Cerrada'); ?></p>
            </div>
        </div>

        <div class="grid sticker-grid gap-4">
            <div class="sticker p-5"><p class="sticker-label">Habilitados</p><p class="sticker-num"><?php echo e($eligibleVoters); ?></p></div>
            <div class="sticker p-5" style="--top:var(--blue)"><p class="sticker-label">Tarjetones</p><p class="sticker-num"><?php echo e($totalBallots); ?></p></div>
            <div class="sticker p-5" style="--top:var(--green)"><p class="sticker-label">Participación</p><p class="sticker-num"><?php echo e($turnoutPercent); ?>%</p></div>
        </div>

        <div class="nb-card">
            <div class="nb-spiral" id="sp-jury-3" data-spiral-count="10"></div>
            <div class="nb-body">
            <h3 class="text-xl font-bold mb-4">Gráfico de participación</h3>
            <canvas id="turnoutChart" height="120"></canvas>
            </div>
        </div>

        <?php if(!$revealWinners): ?>
            <div class="al-warn">Mientras la elección esté activa, no se muestra el ganador.</div>
        <?php else: ?>
            <div class="al-success">Ganador Personero: <?php echo e($personeroWinner?->full_name ?? 'N/A'); ?> | Ganador Contralor: <?php echo e($contralorWinner?->full_name ?? 'N/A'); ?></div>

            <div class="nb-card overflow-x-auto">
                <div class="nb-spiral" id="sp-jury-4" data-spiral-count="10"></div>
                <div class="nb-body">
                <h3 class="text-xl font-bold mb-4">Resultados Personero</h3>
                <table class="min-w-full text-sm">
                    <thead class="text-left text-slate-500 border-b border-slate-200"><tr><th class="py-2 pr-3">Candidato</th><th class="py-2 pr-3">Votos</th><th class="py-2">%</th></tr></thead>
                    <tbody>
                    <?php $__currentLoopData = $personeroResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="border-b border-slate-100"><td class="py-2 pr-3">#<?php echo e($row->display_number); ?> - <?php echo e($row->full_name); ?></td><td class="py-2 pr-3"><?php echo e($row->votes_count); ?></td><td class="py-2"><?php echo e($row->percent); ?>%</td></tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr><td class="py-2 pr-3 font-semibold">Voto en blanco</td><td class="py-2 pr-3 font-semibold"><?php echo e($personeroBlank); ?></td><td></td></tr>
                    </tbody>
                </table>
                </div>
            </div>

            <div class="nb-card overflow-x-auto">
                <div class="nb-spiral" id="sp-jury-5" data-spiral-count="10"></div>
                <div class="nb-body">
                <h3 class="text-xl font-bold mb-4">Resultados Contralor</h3>
                <table class="min-w-full text-sm">
                    <thead class="text-left text-slate-500 border-b border-slate-200"><tr><th class="py-2 pr-3">Candidato</th><th class="py-2 pr-3">Votos</th><th class="py-2">%</th></tr></thead>
                    <tbody>
                    <?php $__currentLoopData = $contralorResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="border-b border-slate-100"><td class="py-2 pr-3">#<?php echo e($row->display_number); ?> - <?php echo e($row->full_name); ?></td><td class="py-2 pr-3"><?php echo e($row->votes_count); ?></td><td class="py-2"><?php echo e($row->percent); ?>%</td></tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr><td class="py-2 pr-3 font-semibold">Voto en blanco</td><td class="py-2 pr-3 font-semibold"><?php echo e($contralorBlank); ?></td><td></td></tr>
                    </tbody>
                </table>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('jury.logout')); ?>">
        <?php echo csrf_field(); ?>
        <button class="w-full md:w-auto h-14 px-8 rounded-2xl bg-slate-700 text-white font-semibold hover:bg-slate-800 transition" type="submit">Cerrar sesión jurado</button>
    </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('turnoutChart');
    if (ctx) {
        new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: ['Votaron', 'Pendientes'],
                datasets: [{
                    data: [<?php echo e($totalBallots ?? 0); ?>, <?php echo e(max(($eligibleVoters ?? 0) - ($totalBallots ?? 0), 0)); ?>],
                    backgroundColor: ['#2563eb', '#cbd5e1']
                }]
            },
            options: {
                plugins: {
                    legend: { position: 'bottom' }
                }
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Francisco\Documents\2026\APLICACIONES APPS\APPLICACIONES\SISVOT\resources\views\jury\dashboard.blade.php ENDPATH**/ ?>