

<?php $__env->startSection('content'); ?>
<div class="nb-card">
    <div class="nb-spiral" id="sp-ballot-main" data-spiral-count="10"></div>
    <div class="nb-body">
    <h1 class="text-2xl md:text-3xl font-bold text-slate-900"><?php echo e($election->name); ?></h1>
    <p class="mt-2 hand text-slate-700">Estudiante: <span class="font-semibold text-slate-800"><?php echo e($student->full_name); ?></span> · <?php echo e($student->grade->name); ?></p>
    <p class="mt-1 text-slate-600"><span class="inline-flex items-center rounded-full px-3 py-1" style="background:var(--yellow); box-shadow:0 3px 0 rgba(0,0,0,.2); font-family:'Fredoka',cursive;">🔒 Voto Secreto</span></p>

    <?php if($errors->has('general')): ?>
        <div class="mt-4 al-err"><?php echo e($errors->first('general')); ?></div>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('voting.submit')); ?>" class="mt-6 space-y-6">
        <?php echo csrf_field(); ?>

        <div class="rounded-2xl border border-slate-200 bg-slate-50 p-4 md:p-6">
            <h3 class="text-xl font-bold mb-4" style="background:var(--blue);color:#fff;padding:.7rem 1rem;border-radius:10px;text-shadow:2px 2px 0 rgba(0,0,0,.2);">Personero</h3>
            <div class="grid vote-grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
                <?php $__currentLoopData = $personeros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $candidate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="vote-option candidate-card cursor-pointer p-3 shadow-sm hover:shadow-md transition">
                        <div class="candidate-top"></div>
                        <input class="vote-radio mb-3 h-4 w-4" type="radio" name="personero_choice" value="<?php echo e($candidate->id); ?>" required>
                        <span class="medal personero"><?php echo e($candidate->display_number); ?></span>
                        <?php
                            $candidateIsImage = $candidate->photo_path && preg_match('/\.(jpg|jpeg|png|gif|webp|bmp|svg)$/i', $candidate->photo_path);
                        ?>
                        <?php if($candidate->photo_url && $candidateIsImage): ?>
                            <img class="w-full h-44 object-cover rounded-xl bg-slate-200" src="<?php echo e($candidate->photo_url); ?>" alt="Foto <?php echo e($candidate->full_name); ?>">
                        <?php elseif($candidate->photo_path): ?>
                            <div class="w-full h-44 rounded-xl bg-slate-200 flex flex-col items-center justify-center text-slate-500 text-sm px-3 text-center">
                                <span class="text-2xl">📄</span>
                                <span class="mt-2 font-medium">Archivo no visualizable</span>
                            </div>
                        <?php else: ?>
                            <div class="w-full h-44 rounded-xl bg-slate-200 flex items-center justify-center text-slate-500 text-sm">Sin foto</div>
                        <?php endif; ?>
                        <span class="role-pill personero">Personero</span>
                        <p class="candidate-name mt-3 text-base text-slate-900"><?php echo e($candidate->full_name); ?></p>
                        <p class="candidate-grade mt-1 text-slate-700">📚 <?php echo e($candidate->grade->name); ?></p>
                        <?php if($candidate->proposal): ?>
                            <p class="candidate-proposal mt-2"><?php echo e($candidate->proposal); ?></p>
                        <?php endif; ?>
                    </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <label class="vote-option candidate-card cursor-pointer p-3 shadow-sm hover:shadow-md transition">
                    <div class="candidate-top"></div>
                    <input class="vote-radio mb-3 h-4 w-4" type="radio" name="personero_choice" value="blanco" required>
                    <div class="w-full h-44 rounded-xl bg-slate-100 flex flex-col items-center justify-center text-slate-600 text-sm px-3 text-center">
                        <span class="text-2xl">🗳️</span>
                        <span class="mt-2 font-semibold">Voto en blanco</span>
                        <span class="mt-1 text-xs">Ningún candidato para personero</span>
                    </div>
                </label>
            </div>
            <?php $__errorArgs = ['personero_choice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="mt-2 text-sm text-red-600"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <div class="rounded-2xl border border-slate-200 bg-slate-50 p-4 md:p-6">
            <h3 class="text-xl font-bold mb-4" style="background:var(--orange);color:#fff;padding:.7rem 1rem;border-radius:10px;text-shadow:2px 2px 0 rgba(0,0,0,.2);">Contralor</h3>
            <div class="grid vote-grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
                <?php $__currentLoopData = $contralores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $candidate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <label class="vote-option candidate-card cursor-pointer p-3 shadow-sm hover:shadow-md transition">
                        <div class="candidate-top contralor"></div>
                        <input class="vote-radio mb-3 h-4 w-4" type="radio" name="contralor_choice" value="<?php echo e($candidate->id); ?>" required>
                        <span class="medal contralor"><?php echo e($candidate->display_number); ?></span>
                        <?php
                            $candidateIsImage = $candidate->photo_path && preg_match('/\.(jpg|jpeg|png|gif|webp|bmp|svg)$/i', $candidate->photo_path);
                        ?>
                        <?php if($candidate->photo_url && $candidateIsImage): ?>
                            <img class="w-full h-44 object-cover rounded-xl bg-slate-200" src="<?php echo e($candidate->photo_url); ?>" alt="Foto <?php echo e($candidate->full_name); ?>">
                        <?php elseif($candidate->photo_path): ?>
                            <div class="w-full h-44 rounded-xl bg-slate-200 flex flex-col items-center justify-center text-slate-500 text-sm px-3 text-center">
                                <span class="text-2xl">📄</span>
                                <span class="mt-2 font-medium">Archivo no visualizable</span>
                            </div>
                        <?php else: ?>
                            <div class="w-full h-44 rounded-xl bg-slate-200 flex items-center justify-center text-slate-500 text-sm">Sin foto</div>
                        <?php endif; ?>
                        <span class="role-pill contralor">Contralor</span>
                        <p class="candidate-name mt-3 text-base text-slate-900"><?php echo e($candidate->full_name); ?></p>
                        <p class="candidate-grade mt-1 text-slate-700">📚 <?php echo e($candidate->grade->name); ?></p>
                        <?php if($candidate->proposal): ?>
                            <p class="candidate-proposal mt-2"><?php echo e($candidate->proposal); ?></p>
                        <?php endif; ?>
                    </label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <label class="vote-option candidate-card cursor-pointer p-3 shadow-sm hover:shadow-md transition">
                    <div class="candidate-top contralor"></div>
                    <input class="vote-radio mb-3 h-4 w-4" type="radio" name="contralor_choice" value="blanco" required>
                    <div class="w-full h-44 rounded-xl bg-slate-100 flex flex-col items-center justify-center text-slate-600 text-sm px-3 text-center">
                        <span class="text-2xl">🗳️</span>
                        <span class="mt-2 font-semibold">Voto en blanco</span>
                        <span class="mt-1 text-xs">Ningún candidato para contralor</span>
                    </div>
                </label>
            </div>
            <?php $__errorArgs = ['contralor_choice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="mt-2 text-sm text-red-600"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <button class="w-full h-16 rounded-2xl bg-blue-600 text-white text-lg font-semibold hover:bg-blue-700 transition" type="submit">Enviar voto</button>
    </form>

    <form method="POST" action="<?php echo e(route('logout')); ?>" class="mt-4">
        <?php echo csrf_field(); ?>
        <button class="w-full h-14 rounded-2xl bg-slate-700 text-white text-base font-semibold hover:bg-slate-800 transition" type="submit">Cerrar sesión</button>
    </form>
    </div>
</div>

<script>
    (function () {
        const radios = document.querySelectorAll('.vote-radio');

        function paintSelection(groupName) {
            document.querySelectorAll('input[name="' + groupName + '"]').forEach(function (radio) {
                const card = radio.closest('.vote-option');
                if (!card) return;

                if (radio.checked) {
                    card.classList.add('selected', 'shadow-md', 'bg-blue-50');
                    card.classList.remove('border-slate-200');
                    card.style.borderColor = radio.name === 'personero_choice' ? 'var(--blue)' : 'var(--orange)';
                } else {
                    card.classList.remove('selected', 'shadow-md', 'bg-blue-50');
                    card.classList.add('border-slate-200');
                    card.style.borderColor = '#ddd';
                }
            });
        }

        radios.forEach(function (radio) {
            radio.addEventListener('change', function () {
                paintSelection(radio.name);
            });
        });

        paintSelection('personero_choice');
        paintSelection('contralor_choice');
    })();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Francisco\Documents\2026\APLICACIONES APPS\APPLICACIONES\SISVOT\resources\views\voting\form.blade.php ENDPATH**/ ?>